`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/12/2023 01:09:27 AM
// Design Name: 
// Module Name: bus
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////
module bus(
        ir_in,
        ir_out,
        inReg_in,
        inReg_out,
        outReg_in,
        outReg_out,
        ac_in,
        ac_out,
        mbr_in,
        mbr_out,
        pc_in,
        pc_out,
        mar_in,
        mar_out,
        ram_in,
        ram_out
    );

parameter width = 16;

input [width-1 : 0] ir_in;
input [width-1 : 0] inReg_in;
input [width-1 : 0] outReg_in;
input [width-1 : 0] ac_in;
input [width-1 : 0] mbr_in;
input [width-1 : 0] pc_in;
input [width-1 : 0] mar_in;
output[width-1 : 0] ir_out;
output[width-1 : 0] inReg_out;
output[width-1 : 0] outReg_out;
output[width-1 : 0] ac_out;
output[width-1 : 0] mbr_out;
output[width-1 : 0] pc_out;
output[width-1 : 0] mar_out;
output[width-1 : 0] ram_in;
output[width-1 : 0] ram_out;

wire [width-1 : 0]  bus;

//Read - take all the inputs and implement the bus - only one register can be read at a time
assign bus = ir_in | inReg_in | outReg_in | ac_in | mbr_in | pc_in | mar_in | ram_in;

//Write - take info from the bus and place it to the entries of the registers; control signals will gate the operation
assign ir_out     = bus;
assign inReg_out  = bus;
assign outReg_out = bus;
assign ac_out     = bus;
assign mbr_out    = bus;
assign pc_out     = bus;
assign mar_out    = bus;
assign ram_out    = bus;

endmodule
